# Ice Converter

Ice Converter is a simple tool that helps you rename, edit, and process `.bgt` files by converting them into `.nvgt` files and applying custom replacements. 

## Features
- Automatically rename `.bgt` files to `.nvgt`.
- Edit `.nvgt` files directly within the app.
- Apply predefined replacements to `.nvgt` files using a `infos.txt` file.
- Create optional backups for safety.

## How to Use
1. **Download and Run**: 
   - click on the `IceConverter.exe` file to start the program.

2. **File Conversion**:
   - Go to the **Convert Files** tab.
   - Select the folder containing `.bgt` files using the directory picker.
   - Click **Start Conversion** to rename `.bgt` files to `.nvgt` and apply replacements.

3. **Edit Files**:
   - Go to the **Edit Files** tab.
   - Select a `.nvgt` file from the list to view or edit.
   - Make changes in the text area and click **Save Changes**.

4. **Settings**:
   - Enable or disable automatic backups from the **Settings** tab.

5. **Replacement Rules**:
   - Ensure a file named `infos.txt` exists in the same folder as the program.
   - Format for `infos.txt`:
     ```
     a=word_to_find b=word_to_replace
     ```

## Requirements
- **Operating System**: Windows 10 or later
- **File Format**: Ensure `.bgt` files are present in the folder you choose.

## Notes
- Backup files will be created in the "backups" folder if enabled in settings.
- Log details can be found in `app.log` for troubleshooting.

## Troubleshooting
If you encounter any issues:
1. Ensure `infos.txt` is correctly formatted.
2. Check the log file (`app.log`) for details.
3. Contact telegram [@FeelingsFrost].

Thank you for using Ice Converter!
